/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.core.world.WorldHandler;
import cofh.lib.util.position.ChunkCoord;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TickHandlerWorld {
    public static TickHandlerWorld instance = new TickHandlerWorld();
    public static TIntObjectHashMap<ArrayDeque<RetroChunkCoord>> chunksToGen = new TIntObjectHashMap();
    public static TIntObjectHashMap<ArrayDeque<ChunkCoord>> chunksToPreGen = new TIntObjectHashMap();
    private static byte pregenC;
    private static byte retroC;

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent worldTickEvent) {
        if (worldTickEvent.side != Side.SERVER) {
            return;
        }
        World world = worldTickEvent.world;
        int n = world.provider.dimensionId;
        if (worldTickEvent.phase == TickEvent.Phase.END) {
            ArrayDeque arrayDeque = (ArrayDeque)chunksToGen.get(n);
            if (arrayDeque != null && arrayDeque.size() > 0) {
                RetroChunkCoord retroChunkCoord = (RetroChunkCoord)arrayDeque.pollFirst();
                ChunkCoord chunkCoord = retroChunkCoord.coord;
                byte by = retroC;
                retroC = (byte)(by + 1);
                if (by == 0 || arrayDeque.size() < 3) {
                    CoFHCore.log.info("RetroGening " + chunkCoord.toString() + ".");
                } else {
                    CoFHCore.log.debug("RetroGening " + chunkCoord.toString() + ".");
                }
                retroC = (byte)(retroC & 0x1F);
                long l = world.getSeed();
                Random random = new Random(l);
                long l2 = random.nextLong() >> 3;
                long l3 = random.nextLong() >> 3;
                random.setSeed(l2 * (long)chunkCoord.chunkX + l3 * (long)chunkCoord.chunkZ ^ l);
                WorldHandler.instance.generateWorld(random, retroChunkCoord, world, false);
                chunksToGen.put(n, (Object)arrayDeque);
            } else if (arrayDeque != null) {
                chunksToGen.remove(n);
            }
        } else {
            ArrayDeque arrayDeque = (ArrayDeque)chunksToPreGen.get(n);
            if (arrayDeque != null && arrayDeque.size() > 0) {
                ChunkCoord chunkCoord = (ChunkCoord)arrayDeque.pollFirst();
                byte by = pregenC;
                pregenC = (byte)(by + 1);
                if (by == 0 || arrayDeque.size() < 5) {
                    CoFHCore.log.info("PreGening " + chunkCoord.toString() + ".");
                } else {
                    CoFHCore.log.debug("PreGening " + chunkCoord.toString() + ".");
                }
                pregenC = (byte)(pregenC & 0x1F);
                world.getChunkFromChunkCoords(chunkCoord.chunkX, chunkCoord.chunkZ);
            } else if (arrayDeque != null) {
                chunksToPreGen.remove(n);
            }
        }
    }

    public static class RetroChunkCoord {
        private static final THashSet<String> emptySet = new THashSet(0);
        public final ChunkCoord coord;
        public final THashSet<String> generatedFeatures;

        public RetroChunkCoord(ChunkCoord chunkCoord, NBTTagList nBTTagList) {
            this.coord = chunkCoord;
            if (nBTTagList == null) {
                this.generatedFeatures = emptySet;
            } else {
                int n = nBTTagList.tagCount();
                this.generatedFeatures = new THashSet(n);
                for (int i = 0; i < n; ++i) {
                    this.generatedFeatures.add((Object)nBTTagList.getStringTagAt(i));
                }
            }
        }

        public boolean equals(Object object) {
            if (object instanceof RetroChunkCoord) {
                return ((RetroChunkCoord)object).coord.equals(this.coord);
            }
            if (object instanceof ChunkCoord) {
                return object.equals(this.coord);
            }
            return false;
        }

        public int hashCode() {
            return this.coord.hashCode();
        }
    }
}

